package computingResource

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"fmt"
	"github.com/gin-gonic/gin"
)

type GetGlobalComputingResourceGroupPartyListHandler struct {
	req  GetGlobalComputingResourceGroupPageReq
	resp common.Response
}

type GetGlobalComputingResourceGroupPartyListReq struct {
	common.BaseRequest
}

type GetGlobalComputingResourceGroupPartyListResp struct {
	GroupPartyIdList []string `json:"groupPartyIdList" binding:"required"`
}

func (h *GetGlobalComputingResourceGroupPartyListHandler) BindReq(c *gin.Context) error {
	fmt.Println(c.ContentType())
	return nil
}

func (h *GetGlobalComputingResourceGroupPartyListHandler) Process() {
	value, err := dbaccess.DBAccessService.GetGlobalPartyId()
	if err != nil {
		logger.Errorf("get global computing resource group failed, err: %v", err)
		h.resp.SetError(common.ErrCodeDataComputingResourceChainFailed, err.Error())
		return
	}

	h.resp.SetData(value)
}

func (h *GetGlobalComputingResourceGroupPartyListHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetGlobalComputingResourceGroupPartyListHandleFunc(c *gin.Context) {
	handler.Run(&GetGlobalComputingResourceGroupPartyListHandler{}, c)
	return
}
