package computingResource

import (
	"chainweaver.org.cn/chainweaver/ida/chain-service/pb/chainpb"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/utils"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types/comm"
	"github.com/gin-gonic/gin"
	"github.com/spf13/cast"
)

type UnpublishComputingResourceGroupHandler struct {
	req  UnpublishComputingResourceGroupReq
	resp common.Response
}

type UnpublishComputingResourceGroupReq struct {
	common.BaseRequest
	GroupId string `json:"groupId"  binding:"required"`
}

func (h *UnpublishComputingResourceGroupHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *UnpublishComputingResourceGroupHandler) Process() {
	platformInfo, err := service.MiraIdaAccessServiceImpl.GetPlatformInfo(uint32(h.req.ChainInfoId), h.req.RequestId)
	if err != nil {
		logger.Errorf("get platform info failed, err: %v", err)
		h.resp.SetError(common.ErrCodeGetPlatformFail, err.Error())
		return
	}

	kvPairs := []*chainpb.KeyValuePair{
		{
			Key:   comm.ParamPartyId,
			Value: []byte(cast.ToString(platformInfo.PlatformId)),
		},
		{
			Key:   comm.ParamGroupId,
			Value: []byte(h.req.GroupId),
		},
	}

	resp, err := service.MiraIdaAccessServiceImpl.InvokeContract(h.req.RequestId, h.req.ChainInfoId, utils.ContractResource, "DeleteComputingResource", kvPairs)
	if err != nil {
		logger.Errorf("unpublish computing resource group failed, err: %v", err)
		h.resp.SetError(common.ErrCodeDataComputingResourceChainFailed, err.Error())
		return
	}
	h.resp.SetData(resp)
}

func (h *UnpublishComputingResourceGroupHandler) GetResponse() *common.Response {
	return &h.resp
}

func UnpublishComputingResourceGroupHandleFunc(c *gin.Context) {
	handler.Run(&UnpublishComputingResourceGroupHandler{}, c)
	return
}
