package confidentialComputingModel

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type GetConfidentialComputingModelDetailHandler struct {
	req  GetConfidentialComputingModelDetailReq
	resp common.Response
}

type GetConfidentialComputingModelDetailReq struct {
	common.BaseRequest
	ModelId string `json:"id" binding:"required"`
}

type GetConfidentialComputingModelDetailResp struct {
	types.ComputingResourceGroup
}

func (h *GetConfidentialComputingModelDetailHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetConfidentialComputingModelDetailHandler) Process() {
	query := make(map[string]interface{})
	query["chain_info_id = ?"] = h.req.ChainInfoId
	query["model_id = ?"] = h.req.ModelId
	value, err := dbaccess.DBAccessService.GetConfidentialComputingModelDetail(query)

	if err != nil {
		logger.Errorf("get confidential computing model detail failed, err: %v", err)
		h.resp.SetError(common.ErrCodeDatConfidentialModelFailed, err.Error())
		return
	}
	h.resp.SetData(value)
}

func (h *GetConfidentialComputingModelDetailHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetConfidentialComputingModelDetailHandleFunc(c *gin.Context) {
	handler.Run(&GetConfidentialComputingModelDetailHandler{}, c)
	return
}
