package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type CreateCertHandler struct {
	req  CreateCertReq
	resp common.Response
}

type CreateCertReq struct {
	types.Cert
}

func (h *CreateCertHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *CreateCertHandler) Process() {
	err := dbaccess.DBAccessService.AddCert(&h.req.Cert)
	if err != nil {
		logger.Errorf("create TLS failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceTLSFailed, err.Error())
	}
	h.resp.SetData("ok")
}

func (h *CreateCertHandler) GetResponse() *common.Response {
	return &h.resp
}

func CreateCertHandleFunc(c *gin.Context) {
	handler.Run(&CreateCertHandler{}, c)
	return
}
