package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type CreateComputingResourceNodeHandler struct {
	req  CreateComputingResourceNodeReq
	resp common.Response
}

type CreateComputingResourceNodeReq struct {
	types.ComputingResourceNodeVo
}

func (h *CreateComputingResourceNodeHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *CreateComputingResourceNodeHandler) Process() {
	err := dbaccess.DBAccessService.AddComputingResourceNodeLocal(&h.req.ComputingResourceNodeVo)
	if err != nil {
		logger.Errorf("create computing resource node failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceNodeFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *CreateComputingResourceNodeHandler) GetResponse() *common.Response {
	return &h.resp
}

func CreateComputingResourceNodeHandleFunc(c *gin.Context) {
	handler.Run(&CreateComputingResourceNodeHandler{}, c)
	return
}
