package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type CreateIpPortPoolHandler struct {
	req  CreateIpPortPoolReq
	resp common.Response
}

type CreateIpPortPoolReq struct {
	types.IPAddress
}

func (h *CreateIpPortPoolHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *CreateIpPortPoolHandler) Process() {
	err := dbaccess.DBAccessService.AddIpPortPool(&h.req.IPAddress)
	if err != nil {
		logger.Errorf("create ip port pool failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourcePoolConfigurationFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *CreateIpPortPoolHandler) GetResponse() *common.Response {
	return &h.resp
}

func CreateIpPortPoolHandleFunc(c *gin.Context) {
	handler.Run(&CreateIpPortPoolHandler{}, c)
	return
}
