package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type CreateSecretKeyHandler struct {
	req  CreateSecretKeyReq
	resp common.Response
}

type CreateSecretKeyReq struct {
	types.SecretKey
}

func (h *CreateSecretKeyHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *CreateSecretKeyHandler) Process() {
	err := service.KeyServiceAccessService.AddSecretKey(&h.req.SecretKey)
	if err != nil {
		logger.Errorf("create secret key failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *CreateSecretKeyHandler) GetResponse() *common.Response {
	return &h.resp
}

func CreateSecretKeyHandleFunc(c *gin.Context) {
	handler.Run(&CreateSecretKeyHandler{}, c)
	return
}
