package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type DeleteCertHandler struct {
	req  DeleteCertReq
	resp common.Response
}

type DeleteCertReq struct {
	types.Cert
}

func (h *DeleteCertHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *DeleteCertHandler) Process() {
	err := dbaccess.DBAccessService.DeleteCert(h.req.CertID)
	if err != nil {
		logger.Errorf("delete TLS failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceTLSFailed, err.Error())
	}
	h.resp.SetData("ok")
}

func (h *DeleteCertHandler) GetResponse() *common.Response {
	return &h.resp
}

func DeleteCertHandleFunc(c *gin.Context) {
	handler.Run(&DeleteCertHandler{}, c)
	return
}
