package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type DeleteComputingResourceNodeHandler struct {
	req  DeleteComputingResourceNodeReq
	resp common.Response
}

type DeleteComputingResourceNodeReq struct {
	types.ComputingResourceNodeVo
}

func (h *DeleteComputingResourceNodeHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *DeleteComputingResourceNodeHandler) Process() {
	err := dbaccess.DBAccessService.DeleteComputingResourceNodeLocalByNodeId(h.req.NodeId)
	if err != nil {
		logger.Errorf("delete computing resource node, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceNodeFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *DeleteComputingResourceNodeHandler) GetResponse() *common.Response {
	return &h.resp
}

func DeleteComputingResourceNodeHandleFunc(c *gin.Context) {
	handler.Run(&DeleteComputingResourceNodeHandler{}, c)
	return
}
