package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type DeleteSecretKeyHandler struct {
	req  DeleteSecretKeyReq
	resp common.Response
}

type DeleteSecretKeyReq struct {
	types.SecretKey
}

func (h *DeleteSecretKeyHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *DeleteSecretKeyHandler) Process() {
	err := service.KeyServiceAccessService.DeleteSecretKey(h.req.SecretKeyID)
	if err != nil {
		logger.Errorf("delete secret key failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *DeleteSecretKeyHandler) GetResponse() *common.Response {
	return &h.resp
}

func DeleteSecretKeyHandleFunc(c *gin.Context) {
	handler.Run(&DeleteSecretKeyHandler{}, c)
	return
}
