package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type GetCertDetailHandler struct {
	req  GetCertDetailReq
	resp common.Response
}

type GetCertDetailReq struct {
	CertId string `json:"certId"  binding:"required"`
}

type GetCertDetailResp struct {
	types.Cert
}

func (h *GetCertDetailHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetCertDetailHandler) Process() {
	value, err := dbaccess.DBAccessService.GetCertById(h.req.CertId)
	if err != nil {
		logger.Errorf("get TLS detail failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceTLSFailed, err.Error())
		return
	}

	if value == nil {
		logger.Error("TLS is nil")
		h.resp.SetError(common.ErrCodeLocalResourceTLSFailed, "TLS is nil")
		return
	}
	resp := &GetCertDetailResp{
		Cert: *value,
	}
	h.resp.SetData(resp)
}

func (h *GetCertDetailHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetCertDetailHandleFunc(c *gin.Context) {
	handler.Run(&GetCertDetailHandler{}, c)
	return
}
