package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type GetCertListHandler struct {
	req  GetCertListReq
	resp common.Response
}

type GetCertListReq struct {
	common.BaseRequest
}

type GetCertListResp struct {
	*types.Cert
}

func (h *GetCertListHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetCertListHandler) Process() {
	value, err := dbaccess.DBAccessService.GetCertList("", -1, -1)
	if err != nil {
		logger.Errorf("get TLS list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceTLSFailed, err.Error())
		return
	}

	if value == nil {
		logger.Error("get TLS  list failed list is nil")
		h.resp.SetError(common.ErrCodeLocalResourceTLSFailed, "TLS list is nil")
		return
	}

	h.resp.SetData(value)
}

func (h *GetCertListHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetCertListHandleFunc(c *gin.Context) {
	handler.Run(&GetCertListHandler{}, c)
	return
}
