package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type GetComputingResourceNodeDetailHandler struct {
	req  GetComputingResourceNodeDetailReq
	resp common.Response
}

type GetComputingResourceNodeDetailReq struct {
	NodeId string `json:"nodeId"  binding:"required"`
}

type GetComputingResourceNodeDetailResp struct {
	types.ComputingResourceNodeVo
}

func (h *GetComputingResourceNodeDetailHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetComputingResourceNodeDetailHandler) Process() {
	value, err := dbaccess.DBAccessService.GetComputingResourceNodeDetailLocalByNodeId(h.req.NodeId)
	if err != nil {
		logger.Errorf("get computing resource node detail failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}

	if value == nil {
		logger.Error("computing resource node detail is nil")
		h.resp.SetError(common.ErrCodeLocalResourceNodeFailed, "computing resource node detail is nil")
		return
	}
	resp := &GetComputingResourceNodeDetailResp{
		ComputingResourceNodeVo: *value,
	}
	h.resp.SetData(resp)
}

func (h *GetComputingResourceNodeDetailHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetComputingResourceNodeDetailHandleFunc(c *gin.Context) {
	handler.Run(&GetComputingResourceNodeDetailHandler{}, c)
	return
}
