package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types/comm"
	"github.com/gin-gonic/gin"
)

type GetComputingResourceNodeListPageHandler struct {
	req  GetComputingResourceNodeListPageReq
	resp common.Response
}

type GetComputingResourceNodeListPageReq struct {
	comm.ListInterfaceReq
}

type GetComputingResourceNodeListPageResp struct {
	comm.ListInterfaceResp[*types.ComputingResourceNodeVo]
}

func (h *GetComputingResourceNodeListPageHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetComputingResourceNodeListPageHandler) Process() {
	offset := h.req.PageSize * (h.req.PageNumber - 1)
	value, err := dbaccess.DBAccessService.GetComputingResourceNodeLocalList("", offset, h.req.PageSize)
	if err != nil {
		logger.Errorf("get computing resource node list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeDataComputingResourceListNotFound, err.Error())
		return
	}

	if value == nil {
		logger.Error("computing resource node list is nil")
		h.resp.SetError(common.ErrCodeDataComputingResourceListNotFound, "computing resource node list is nil")
		return
	}

	count, err := dbaccess.DBAccessService.GetCertListCount("")
	if err != nil {
		logger.Errorf("get total of computing resource node list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeDataComputingResourceListNotFound, err.Error())
		return
	}

	resp := &GetComputingResourceNodeListPageResp{
		ListInterfaceResp: comm.ListInterfaceResp[*types.ComputingResourceNodeVo]{
			Pagination: comm.Pagination{
				Total:      int(count),
				PageSize:   h.req.PageSize,
				PageNumber: h.req.PageNumber,
			},
			List: value,
		},
	}
	h.resp.SetData(resp)
}

func (h *GetComputingResourceNodeListPageHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetComputingResourceNodeListPageHandleFunc(c *gin.Context) {
	handler.Run(&GetComputingResourceNodeListPageHandler{}, c)
	return
}
