package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type GetIpPortPoolHandler struct {
	req  GetIpPortPoolReq
	resp common.Response
}

type GetIpPortPoolReq struct {
}

type GetIpPortPoolResp struct {
	types.IPAddress
}

func (h *GetIpPortPoolHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetIpPortPoolHandler) Process() {
	value, err := dbaccess.DBAccessService.GetIpPortPool()
	if err != nil {
		logger.Errorf("create ip port pool failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourcePoolConfigurationFailed, err.Error())
		return
	}

	if value == nil {
		logger.Error("ip port pool is nil")
		h.resp.SetError(common.ErrCodeLocalResourcePoolConfigurationNotFound, "ip port pool is nil")
		return
	}
	resp := &GetIpPortPoolResp{
		IPAddress: *value,
	}
	h.resp.SetData(resp)
}

func (h *GetIpPortPoolHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetIpPortPoolHandleFunc(c *gin.Context) {
	handler.Run(&GetIpPortPoolHandler{}, c)
	return
}
