package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
	"strconv"
)

type GetPartyInfoHandler struct {
	req  GetPartyInfoReq
	resp common.Response
}

type GetPartyInfoReq struct {
	common.BaseRequest
}

type GetPartyInfoResp struct {
	PartyId   string `json:"partyId"`
	PartyName string `json:"partyName"`
}

func (h *GetPartyInfoHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetPartyInfoHandler) Process() {
	value, err := service.MiraIdaAccessServiceImpl.GetPlatformInfo(uint32(h.req.ChainInfoId), h.req.RequestId)
	if err != nil {
		logger.Errorf("get platform info failed, err: %v", err)
		h.resp.SetError(common.ErrCodeGetPlatformFail, err.Error())
		return
	}

	if value == nil {
		h.resp.SetError(common.ErrCodeGetPlatformFail, "platform info is nil")
		return
	}
	resp := &GetPartyInfoResp{
		PartyId:   strconv.Itoa(int(value.PlatformId)),
		PartyName: value.PlatformName,
	}
	h.resp.SetData(resp)
}

func (h *GetPartyInfoHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetPartyInfoHandleFunc(c *gin.Context) {
	handler.Run(&GetPartyInfoHandler{}, c)
	return
}
