package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type GetSecretKeyDetailHandler struct {
	req  GetSecretKeyDetailReq
	resp common.Response
}

type GetSecretKeyDetailReq struct {
	SecretKeyId string `json:"secretKeyId"  binding:"required"`
}

type GetSecretKeyDetailResp struct {
	types.SecretKey
}

func (h *GetSecretKeyDetailHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetSecretKeyDetailHandler) Process() {
	value, err := service.KeyServiceAccessService.GetSecretKeyById(h.req.SecretKeyId)
	if err != nil {
		logger.Errorf("get secret key detail failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}

	if value == nil {
		logger.Error("secret key is nil")
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, "secret key is nil")
		return
	}
	resp := &GetSecretKeyDetailResp{
		SecretKey: *value,
	}
	h.resp.SetData(resp)
}

func (h *GetSecretKeyDetailHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetSecretKeyDetailHandleFunc(c *gin.Context) {
	handler.Run(&GetSecretKeyDetailHandler{}, c)
	return
}
