package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type GetSecretKeyListHandler struct {
	req  GetSecretKeyListReq
	resp common.Response
}

type GetSecretKeyListReq struct {
	common.BaseRequest
}

type GetSecretKeyListResp struct {
	*types.SecretKey
}

func (h *GetSecretKeyListHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetSecretKeyListHandler) Process() {
	value, err := service.KeyServiceAccessService.GetSecretKeyList("", -1, -1)
	if err != nil {
		logger.Errorf("get secret key list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}

	if value == nil {
		logger.Error("get secret key list failed list is nil")
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, "secret key list is nil")
		return
	}

	h.resp.SetData(value)
}

func (h *GetSecretKeyListHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetSecretKeyListHandleFunc(c *gin.Context) {
	handler.Run(&GetSecretKeyListHandler{}, c)
	return
}
