package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types/comm"
	"github.com/gin-gonic/gin"
)

type GetSecretKeyListPageHandler struct {
	req  GetSecretKeyListPageReq
	resp common.Response
}

type GetSecretKeyListPageReq struct {
	comm.ListInterfaceReq
}

type GetSecretKeyListPageResp struct {
	comm.ListInterfaceResp[*types.SecretKey]
}

func (h *GetSecretKeyListPageHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetSecretKeyListPageHandler) Process() {
	offset := h.req.PageSize * (h.req.PageNumber - 1)
	value, err := service.KeyServiceAccessService.GetSecretKeyList("", offset, h.req.PageSize)
	if err != nil {
		logger.Errorf("get secret key list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}

	if value == nil {
		logger.Error("get secret key list failed list is nil")
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, "secret key lis is nil")
		return
	}

	count, err := service.KeyServiceAccessService.GetSecretKeyListCount("")
	if err != nil {
		logger.Errorf("get total of get secret key list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}

	resp := &GetSecretKeyListPageResp{
		ListInterfaceResp: comm.ListInterfaceResp[*types.SecretKey]{
			Pagination: comm.Pagination{
				Total:      int(count),
				PageSize:   h.req.PageSize,
				PageNumber: h.req.PageNumber,
			},
			List: value,
		},
	}
	h.resp.SetData(resp)
}

func (h *GetSecretKeyListPageHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetSecretKeyListPageHandleFunc(c *gin.Context) {
	handler.Run(&GetSecretKeyListPageHandler{}, c)
	return
}
