package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type UpdateCertHandler struct {
	req  UpdateCertReq
	resp common.Response
}

type UpdateCertReq struct {
	types.Cert
}

func (h *UpdateCertHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *UpdateCertHandler) Process() {
	err := dbaccess.DBAccessService.UpdateCert(&h.req.Cert)
	if err != nil {
		logger.Errorf("update TLS failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceTLSFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *UpdateCertHandler) GetResponse() *common.Response {
	return &h.resp
}

func UpdateCertHandleFunc(c *gin.Context) {
	handler.Run(&UpdateCertHandler{}, c)
	return
}
