package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type UpdateComputingResourceNodeHandler struct {
	req  UpdateComputingResourceNodeReq
	resp common.Response
}

type UpdateComputingResourceNodeReq struct {
	types.ComputingResourceNodeVo
}

func (h *UpdateComputingResourceNodeHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *UpdateComputingResourceNodeHandler) Process() {
	err := dbaccess.DBAccessService.UpdateComputingResourceNodeLocal(&h.req.ComputingResourceNodeVo)
	if err != nil {
		logger.Errorf("update computing resource node, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceNodeFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *UpdateComputingResourceNodeHandler) GetResponse() *common.Response {
	return &h.resp
}

func UpdateComputingResourceNodeHandleFunc(c *gin.Context) {
	handler.Run(&UpdateComputingResourceNodeHandler{}, c)
	return
}
