package configuration

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
)

type UpdateSecretKeyHandler struct {
	req  UpdateSecretKeyReq
	resp common.Response
}

type UpdateSecretKeyReq struct {
	types.SecretKey
}

func (h *UpdateSecretKeyHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *UpdateSecretKeyHandler) Process() {
	err := service.KeyServiceAccessService.UpdateSecretKey(&h.req.SecretKey)
	if err != nil {
		logger.Errorf("update secret key failed, err: %v", err)
		h.resp.SetError(common.ErrCodeLocalResourceSecurityFailed, err.Error())
		return
	}
	h.resp.SetData("ok")
	return
}

func (h *UpdateSecretKeyHandler) GetResponse() *common.Response {
	return &h.resp
}

func UpdateSecretKeyHandleFunc(c *gin.Context) {
	handler.Run(&UpdateSecretKeyHandler{}, c)
	return
}
