package health

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
)

type HealthHandler struct {
	req  common.BaseRequest
	resp common.Response
}

func (h *HealthHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *HealthHandler) Process() {
	h.resp.SetData("ok")
}

func (h *HealthHandler) GetResponse() *common.Response {
	return &h.resp
}

func HandleFunc(c *gin.Context) {
	handler.Run(&HealthHandler{}, c)
	return
}
