package job

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
)

type CancelJobHandler struct {
	req  CancelJobIInstancesReq
	resp common.Response
}

type CancelJobIInstancesReq struct {
	common.BaseRequest

	JobInstanceId string `json:"jobInstanceId"  binding:"required"` // 任务ID
}

func (h *CancelJobHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *CancelJobHandler) Process() {
	// 根据JobId查询Instance信息
	instances, err := dbaccess.DBAccessService.GetJobInstanceByJobId(h.req.JobInstanceId)
	if err != nil {
		logger.Errorf("get job instance failed, err: %v", err)
		h.resp.SetError(common.ErrCodeGetInstanceByJobIdFail, err.Error())
		return
	}

	req := h.req

	for _, instance := range instances {
		// 取消任务实例
		_, err = service.MiraIdaAccessServiceImpl.CancelJobInstance(req.RequestId, req.ChainInfoId, instance.JobInstanceId)
		if err != nil {
			logger.Errorf("create job failed, err: %v", err)
			h.resp.SetError(common.ErrCodePutJobContract, err.Error())
			return
		}
		logger.Info("close job instance id", instance.JobInstanceId)
	}
	h.resp.SetData(nil)
}

func (h *CancelJobHandler) GetResponse() *common.Response {
	return &h.resp
}

func CancelJobHandleFunc(c *gin.Context) {
	handler.Run(&CancelJobHandler{}, c)
	return
}
func NewCancelJobHandler(baseRequest common.BaseRequest, jobInstanceId string) *CancelJobHandler {
	return &CancelJobHandler{
		req: CancelJobIInstancesReq{
			BaseRequest:   baseRequest,
			JobInstanceId: jobInstanceId,
		},
	}
}
