package job

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/gin-gonic/gin"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/assert"
	"net/http/httptest"
	"strings"
	"testing"
)

func newCancelJobHandler() *CancelJobHandler {
	return &CancelJobHandler{
		req:  CancelJobIInstancesReq{},
		resp: common.Response{},
	}
}

func TestCancelJobHandler_BindReq(t *testing.T) {
	handler := newCancelJobHandler()
	// 准备 HTTP 请求上下文
	c, _ := gin.CreateTestContext(httptest.NewRecorder())

	// 准备请求 JSON

	// 绑定请求
	c.Request = httptest.NewRequest("POST", "/test", strings.NewReader(cancelJobRequestJSON))
	err := handler.BindReq(c)

	// 验证绑定是否成功
	assert.NoError(t, err)
	assert.Equal(t, "34467774-ABA1-422C-BB76-962E5952FC25", handler.req.RequestId)
	assert.Equal(t, "5526b91f_d3cb_4f87_be0c_eae45bf18c23", handler.req.JobInstanceId)
	t.Log(handler.req)
}

func TestCancelJobHandler_Process(t *testing.T) {
	handler := newCancelJobHandler()
	// 准备 HTTP 请求上下文
	c, _ := gin.CreateTestContext(httptest.NewRecorder())

	// 准备请求 JSON

	// 绑定请求
	c.Request = httptest.NewRequest("POST", "/test", strings.NewReader(cancelJobRequestJSON))
	err := handler.BindReq(c)

	// 验证绑定是否成功
	assert.NoError(t, err)

	// mock
	ctl := gomock.NewController(t)
	defer ctl.Finish()
	mockDBAccessInterface := dbaccess.NewMockDBAccessInterface(ctl)
	mockDBAccessInterface.EXPECT().GetJobInstanceByJobId(gomock.Any()).Return([]*types.JobInstance{{}, {}}, nil)
	// 初始化DB
	dbaccess.DBAccessService = mockDBAccessInterface

	mockMiraIdaAccessServiceImpl := service.NewMockMiraIdaAccessService(ctl)
	mockMiraIdaAccessServiceImpl.EXPECT().CancelJobInstance(gomock.Any(), gomock.Any(), gomock.Any()).Return("", nil).Times(2)
	service.MiraIdaAccessServiceImpl = mockMiraIdaAccessServiceImpl

	// 处理请求
	handler.Process()

	// 验证响应是否包含错误
	assert.Equal(t, common.ErrCodeOK, handler.resp.Code)
}

var cancelJobRequestJSON = `{
  "RequestId": "34467774-ABA1-422C-BB76-962E5952FC25",
  "UserId": "123456",
  "ChainInfoId": 1,
  "jobId": "5526b91f_d3cb_4f87_be0c_eae45bf18c23"
}`
