package job

import (
	"chainweaver.org.cn/chainweaver/ida/chain-service/pb/chainpb"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/assert"
	"net/http"
	"testing"
)

func TestGetJobApproveHandler_Process(t *testing.T) {
	// mock
	ctl := gomock.NewController(t)
	defer ctl.Finish()

	var (
		jobId       = "5526b91f_d3cb_4f87_be0c_eae45bf18c23"
		requestId   = "34467774-ABA1-422C-BB76-962E5952FC25"
		userId      = "123456"
		chainInfoId = 1
	)

	mockDBAccessInterface := dbaccess.NewMockDBAccessInterface(ctl)
	mockDBAccessInterface.EXPECT().GetJobApproveInfo(jobId).Return(&types.JobApproveInfo{
		JobId: jobId,
		JobSummaryInfo: &types.JobSummaryInfo{
			JobId: jobId,
		},
	}, nil)

	// 初始化DB
	dbaccess.DBAccessService = mockDBAccessInterface

	// mock GRPC
	mockMiraIdaAccessService := service.NewMockMiraIdaAccessService(ctl)
	mockMiraIdaAccessService.EXPECT().GetPlatformInfo(uint32(1), requestId).Return(&chainpb.PlatformData{}, nil)

	service.MiraIdaAccessServiceImpl = mockMiraIdaAccessService

	handler := &GetJobApproveHandler{
		req: GetJobApproveReq{
			BaseRequest: common.BaseRequest{
				RequestId:   requestId,
				UserId:      userId,
				ChainInfoId: chainInfoId,
			},
			JobId: jobId,
		},
		resp: common.Response{},
	}
	handler.Process()

	resp := handler.GetResponse()
	assert.Equal(t, http.StatusOK, resp.Code)

	data := resp.Data.(*GetJobApproveResp)
	assert.Equal(t, jobId, data.JobApproveInfo.JobId)
}
