package job

import (
	"github.com/stretchr/testify/assert"
	"net/http"
	"net/http/httptest"
	"testing"
)

func TestReadByteFromUrl(t *testing.T) {
	server := httptest.NewServer(http.HandlerFunc(func(writer http.ResponseWriter, request *http.Request) {
		_, _ = writer.Write([]byte(`{"jobId":"5526b91f_d3cb_4f87_be0c_eae45bf18c23"}`))
	}))
	defer server.Close()
	data := map[string]interface{}{}
	result, err := ReadByteFromUrl(server.URL, nil, &data)
	assert.NoError(t, err)
	assert.Equal(t, map[string]interface{}{"jobId": "5526b91f_d3cb_4f87_be0c_eae45bf18c23"}, data)
	assert.Equal(t, []byte(`{"jobId":"5526b91f_d3cb_4f87_be0c_eae45bf18c23"}`), result)
}
