package job

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types/comm"
	"github.com/golang/mock/gomock"
	"github.com/stretchr/testify/assert"
	"net/http"
	"testing"
)

func TestGetJobInstanceListHandler_Process(t *testing.T) {
	// mock
	ctl := gomock.NewController(t)
	defer ctl.Finish()

	var (
		jobId         = "5526b91f_d3cb_4f87_be0c_eae45bf18c23"
		jobInstanceNo = "jobInstanceNo"
		requestId     = "34467774-ABA1-422C-BB76-962E5952FC25"
		userId        = "123456"
		chainInfoId   = 1
	)

	mockDBAccessInterface := dbaccess.NewMockDBAccessInterface(ctl)
	mockDBAccessInterface.EXPECT().GetJobInstanceCountByJobId(jobId).Return(int64(11), nil)
	mockDBAccessInterface.EXPECT().GetJobInstanceListLimitByJobId(jobId, 10, 10).Return([]*types.JobInstance{
		{
			JobId:         jobId,
			JobInstanceId: jobInstanceNo,
		},
	}, nil)

	// 初始化DB
	dbaccess.DBAccessService = mockDBAccessInterface

	handler := &GetJobInstanceListHandler{
		req: GetJobInstanceListReq{
			BaseRequest: common.BaseRequest{
				RequestId:   requestId,
				UserId:      userId,
				ChainInfoId: chainInfoId,
			},
			ListInterfaceReq: comm.ListInterfaceReq{
				PageNumber: 2,
				PageSize:   10,
			},
			JobId: jobId,
		},
		resp: common.Response{},
	}
	handler.Process()

	resp := handler.GetResponse()
	assert.Equal(t, http.StatusOK, resp.Code)

	data := resp.Data.(*comm.ListInterfaceResp[JobInstanceInfo])
	assert.Equal(t, jobId, data.List[0].JobId)
}
