package job

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/minio_access"
	"github.com/gin-gonic/gin"
)

type GetResultUrlHandler struct {
	req  GetResultUrlReq
	resp common.Response
}

type GetResultUrlReq struct {
	common.BaseRequest
	ObjectName string `json:"object_name"`
}

type Response struct {
	Code    int              `json:"code"`
	Message string           `json:"message"`
	Data    GetResultUrlResp `json:"data"`
}

type GetResultUrlResp struct {
	ResultUrl string `json:"resultUrl"`
}

func (h *GetResultUrlHandler) BindReq(c *gin.Context) error {
	// ChainInfoId 设置默认值
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetResultUrlHandler) Process() {
	url, err := minio_access.MinioAccessService.GetResultUrl(h.req.ObjectName)
	if err != nil {
		logger.Errorf("get job instance failed, err: %v", err)
		h.resp.SetError(common.ErrCodeGetInstanceByJobIdFail, err.Error())
		return
	}
	resp := GetResultUrlResp{
		ResultUrl: url,
	}
	h.resp.SetData(resp)
}

func (h *GetResultUrlHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetResultUrlHandleFunc(c *gin.Context) {
	handler.Run(&GetResultUrlHandler{}, c)
	return
}
