package job

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
	"github.com/google/uuid"
)

type SetResultServerAddrHandle struct {
	req  SetResultServerAddrReq
	resp common.Response
}

type SetResultServerAddrReq struct {
	common.BaseRequest

	ChainInfoId int32  `json:"chainInfoId"  binding:"required"`
	Address     string `json:"address"  binding:"required"`
}

func (h *SetResultServerAddrHandle) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *SetResultServerAddrHandle) Process() {
	platformInfo, err := service.MiraIdaAccessServiceImpl.GetPlatformInfo(uint32(h.req.ChainInfoId), uuid.New().String())
	if err != nil {
		logger.Errorf("GetPlatformInfo error: %v", err)
		return
	}
	if platformInfo == nil {
		logger.Errorf("GetPlatformInfo error: platfromInfo is nil")
		return
	}

	err = service.MiraIdaAccessServiceImpl.SetResultServerAddr(h.req.RequestId, h.req.ChainInfoId, platformInfo.PlatformId, h.req.Address)
	if err != nil {
		logger.Errorf("SetResultServerAddr error: %v", err)
		h.resp.SetError(common.ErrCodeSetResultServerAddrFail, err.Error())
		return
	}
	h.resp.SetData(nil)
}

func (h *SetResultServerAddrHandle) GetResponse() *common.Response {
	return &h.resp
}

func SetResultServerAddrHandleFunc(c *gin.Context) {
	handler.Run(&SetResultServerAddrHandle{}, c)
	return
}
