package job

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
)

type StartJobHandler struct {
	req  StartJobReq
	resp common.Response
}

type StartJobReq struct {
	common.BaseRequest
	JobId string `json:"jobId"`
}

func (h *StartJobHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *StartJobHandler) Process() {
	_, err := service.MiraIdaAccessServiceImpl.TriggerJobEnable(h.req.RequestId, h.req.ChainInfoId, h.req.JobId)
	if err != nil {
		logger.Errorf("create job failed, err: %v", err)
		h.resp.SetError(common.ErrCodePutJobContract, err.Error())
		return
	}

	h.resp.SetData("success")
}

func (h *StartJobHandler) GetResponse() *common.Response {
	return &h.resp
}

func StartJobHandleFunc(c *gin.Context) {
	handler.Run(&StartJobHandler{}, c)
	return
}
