/**
 * @Author: xueyanghan
 * @File: errors.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/9 15:10
 */

package common

const (
	// ErrCodeOK -  Default error codes
	ErrCodeOK      = 200
	ErrCodeUnknown = 69999

	// ErrCodeInvalidParameter - Common error codes: 60000 - 60099
	ErrCodeInvalidParameter      = 60000
	ErrCodeInvalidParameterValue = 60001
	ErrCodeMissingParameter      = 60002
	ErrCodeUnknownParameter      = 60003
	ErrCodeInternalError         = 60004
	ErrCodeProtoToBean           = 60005

	// ErrCodeGetAssetByIdFailed - resource management error codes: 61000 - 61999
	ErrCodeGetAssetByIdFailed                  = 61000
	ErrCodeGetAssetListFailed                  = 61001
	ErrCodeGetEnterpriseListFailed             = 61002
	ErrCodeGetAssetByEnNameFailed              = 61003
	ErrCodeDataComputingResourceListNotFound   = 61021
	ErrCodeDataComputingResourceDetailNotFound = 61022
	ErrCodeDataComputingResourceChainFailed    = 61023
	ErrCodeDataConfidentialModelListNotFound   = 61024
	ErrCodeDataConfidentialModelDetailNotFound = 61025
	ErrCodeDatConfidentialModelChainFailed     = 61026
	ErrCodeDatConfidentialModelFailed          = 61027

	// ErrCodeGetJobContract - job management error codes: 62000 - 62999
	ErrCodeGetJobContract            = 62000
	ErrCodeGetJobListContract        = 62001
	ErrCodeUpdatePortFail            = 62002
	ErrCodePutJobContract            = 62003
	ErrCodeQueryJobsContract         = 62004
	ErrCodeQueryAllJobsContract      = 62005
	ErrCodePreviewDAGFail            = 62006
	ErrCodeCommitDAGFail             = 62007
	ErrCodeCancelJobRequestFail      = 62008
	ErrGetPlatformPKFail             = 62009
	ErrCodeJobDetailParameter        = 62020
	ErrCodeCreateJobApproveContract  = 62021
	ErrCodeGetJobApproveListContract = 62022
	ErrCodeGetJobApproveContract     = 62023
	ErrCodeGetJobFromDB              = 62024

	ErrCodePutJob                  = 62025
	ErrCodeGetJob                  = 62026
	ErrCodeGetJobList              = 62027
	ErrCodeCreateJobApprove        = 62028
	ErrCodeGetJobApprove           = 62029
	ErrCodeGetJobApproveList       = 62030
	ErrCodeGetDAGFail              = 62031
	ErrCodeGetPlatformFail         = 62032
	ErrCodeGetInstanceByJobIdFail  = 62033
	ErrCodeSetResultServerAddrFail = 62034

	// ErrCodeLocalResourceError - local resource management error codes: 63000 - 63999
	ErrCodeLocalResourceError                       = 63000
	ErrCodeLocalResourcePoolConfigurationFailed     = 63001
	ErrCodeLocalResourcePoolConfigurationNotFound   = 63002
	ErrCodeLocalResourceSecurityListNotFound        = 63003
	ErrCodeLocalResourceSecurityFailed              = 63004
	ErrCodeLocalResourceTLSListNotFound             = 63005
	ErrCodeLocalResourceTLSFailed                   = 63006
	ErrCodeLocalResourceNodeListNotFound            = 63007
	ErrCodeLocalResourceNodeFailed                  = 63008
	ErrCodeLocalResourcePlatformInformationNotFound = 63020
	ErrCodeLocalResourceAvailableAddressFailed      = 63021
	ErrCodeDownloadMinio                            = 63022
	ErrCodeUploadMinio                              = 63023
	ErrGetMinioResult                               = 63024
	ErrCodeGetAddressByDomainId                     = 63025
	ErrCodeDecrypt                                  = 63026
	ErrCodeSaveContentToFile                        = 63027
	ErrCodeGetUrlContent                            = 63028
	ErrCodeGetAvailableAddrList                     = 63029
	ErrCodeMinioKeyIsNotCorrect                     = 63030
	ErrCodeDataIdIsEmpty                            = 63031
)

var ErrCodeMessage = map[int]string{
	// 通用错误信息
	ErrCodeOK:                    "成功",
	ErrCodeUnknown:               "错误未识别",
	ErrCodeInvalidParameter:      "参数错误（包括参数格式、类型等错误）",
	ErrCodeInvalidParameterValue: "参数取值错误",
	ErrCodeMissingParameter:      "缺少参数错误，必传参数没填",
	ErrCodeUnknownParameter:      "未知参数错误，用户多传未定义的参数会导致错误",
	ErrCodeInternalError:         "网络错误",
	ErrCodeProtoToBean:           "Proto转Bean失败",

	// 资源管理错误信息
	ErrCodeGetAssetByIdFailed:                  "根据id获取数据资产失败",
	ErrCodeGetAssetListFailed:                  "数据资产列表获取失败",
	ErrCodeGetEnterpriseListFailed:             "企业列表查询失败",
	ErrCodeGetAssetByEnNameFailed:              "根据EnName获取数据资产失败",
	ErrCodeDataComputingResourceListNotFound:   "算力资源列表获取失败",
	ErrCodeDataComputingResourceDetailNotFound: "算力资源详情获取失败",
	ErrCodeDataComputingResourceChainFailed:    "算力资源与链交互失败",
	ErrCodeDataConfidentialModelListNotFound:   "机密计算模型列表获取失败",
	ErrCodeDataConfidentialModelDetailNotFound: "机密计算模型详情获取失败",
	ErrCodeDatConfidentialModelChainFailed:     "机密计算模型与链交互失败",
	ErrCodeDatConfidentialModelFailed:          "机密计算模型操作失败",

	// 任务管理错误信息
	ErrCodeGetJobContract:            "任务信息查询链失败",
	ErrCodeGetJobListContract:        "任务列表查询链失败",
	ErrCodeUpdatePortFail:            "新增任务更新端口失败",
	ErrCodePutJobContract:            "新增任务上链失败",
	ErrCodeQueryJobsContract:         "Job信息查询链失败",
	ErrCodeQueryAllJobsContract:      "Job列表查询链失败",
	ErrCodePreviewDAGFail:            "获取DAG信息失败",
	ErrCodeCommitDAGFail:             "提交DAG信息失败",
	ErrCodeCancelJobRequestFail:      "取消Job请求失败",
	ErrGetPlatformPKFail:             "通过平台id获取公钥失败",
	ErrCodeJobDetailParameter:        "任务详情参数错误",
	ErrCodeCreateJobApproveContract:  "任务审批上链失败",
	ErrCodeGetJobApproveListContract: "任务审批列表查询链失败",
	ErrCodeGetJobApproveContract:     "任务审批详情查询链失败",
	ErrCodeGetJobFromDB:              "任务信息查询数据库失败",

	ErrCodePutJob:                 "新增任务失败",
	ErrCodeGetJob:                 "任务详情查询失败",
	ErrCodeGetJobList:             "任务列表查询失败",
	ErrCodeCreateJobApprove:       "新增任务审批失败",
	ErrCodeGetJobApprove:          "任务审批详情查询失败",
	ErrCodeGetJobApproveList:      "任务审批列表查询失败",
	ErrCodeGetDAGFail:             "查询DAG信息失败",
	ErrCodeGetPlatformFail:        "获取平台信息失败",
	ErrCodeGetInstanceByJobIdFail: "根据任务ID获取任务实例失败",

	// 本地资源管理错误信息

	ErrCodeLocalResourceError:                       "本地资源错误",
	ErrCodeLocalResourcePoolConfigurationFailed:     "IP和端口池配置失败",
	ErrCodeLocalResourcePoolConfigurationNotFound:   "IP和端口池获取失败",
	ErrCodeLocalResourceSecurityListNotFound:        "加密公私钥列表获取失败",
	ErrCodeLocalResourceSecurityFailed:              "加密公私钥操作失败",
	ErrCodeLocalResourceTLSListNotFound:             "TLS通讯证书列表获取失败",
	ErrCodeLocalResourceTLSFailed:                   "TLS通讯证书操作失败",
	ErrCodeLocalResourceNodeListNotFound:            "本地算力节点列表获取失败",
	ErrCodeLocalResourceNodeFailed:                  "本地算力节点操作失败",
	ErrCodeLocalResourcePlatformInformationNotFound: "平台信息获取失败",
	ErrCodeLocalResourceAvailableAddressFailed:      "获取可用的地址列表失败",
	ErrCodeMinioKeyIsNotCorrect:                     "minio key错误",
	ErrCodeDataIdIsEmpty:                            "data id为空",

	ErrCodeDownloadMinio:        "minio下载文件失败",
	ErrCodeUploadMinio:          "minio上传文件失败",
	ErrGetMinioResult:           "获取加密结果失败",
	ErrCodeGetAddressByDomainId: "根据组织id查询地址失败",
	ErrCodeDecrypt:              "解密失败",
	ErrCodeSaveContentToFile:    "保存文件失败",
	ErrCodeGetUrlContent:        "获取URL内容失败",
	ErrCodeGetAvailableAddrList: "获取空闲地址列表失败",
}
