package common

type Response struct {
	Code int         `json:"code"`
	Msg  string      `json:"message"`
	Data interface{} `json:"data"`
}

func (r *Response) SetErrCode(errCode int) {
	r.Code = errCode
	r.Msg = ErrCodeMessage[errCode]
}

func (r *Response) SetErrMsg(errMsg string) {
	r.Msg = errMsg
}

func (r *Response) SetData(data interface{}) {
	r.Code = ErrCodeOK
	r.Data = data
}

func (r *Response) SetError(errCode int, errMsg string) {
	r.SetErrCode(errCode)
	r.SetErrMsg(errMsg)
}
