/**
 * @Author: xueyanghan
 * @File: handler.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2023/4/5 14:37
 */

package handler

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"github.com/gin-gonic/gin"
	"net/http"
)

type IHandler interface {
	BindReq(c *gin.Context) error
	Process()

	GetResponse() *common.Response
}

// Run api handler run
func Run(handler IHandler, c *gin.Context) {
	if err := handler.BindReq(c); err != nil {
		return
	}

	handler.Process()

	resp := handler.GetResponse()
	if resp.Code != common.ErrCodeOK {
		c.JSON(http.StatusOK, &common.Response{
			Code: resp.Code,
			Msg:  resp.Msg,
			Data: nil,
		})
		return
	}

	c.JSON(http.StatusOK, &common.Response{
		Code: common.ErrCodeOK,
		Msg:  resp.Msg,
		Data: resp.Data,
	})
}
