/**
 * @Author: xueyanghan
 * @File: router_register.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2023/5/23 18:53
 */

package ctrl

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/config"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/asset"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/computingResource"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/confidentialComputingModel"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/configuration"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/health"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/job"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/jobInstance"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/apis/port"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/middleware"
	"github.com/gin-gonic/gin"
)

func InitRouter(r *gin.Engine) {
	r.Use(middleware.WebLogMiddleware())
	r.Use(middleware.HeaderToBodyMiddleware())
	rootGroup := r.Group(config.Conf.Common.UrlPrefix)
	{
		// health check
		rootGroup.POST("/health", health.HandleFunc)
	}

	// asset handlers
	assetGroup := rootGroup.Group("/asset")
	{
		assetGroup.POST("/GetAsset", asset.GetAssetInfoHandleFunc)
		assetGroup.POST("/GetAssetList", asset.GetAssetListHandleFunc)
		assetGroup.POST("/GetEnterpriseList", asset.GetEnterpriseListHandlerFunc)
	}

	// job handlers
	jobGroup := rootGroup.Group("/job")
	{
		jobGroup.POST("/CreateJob", job.CreateJobHandleFunc)
		jobGroup.POST("/GetJob", job.GetJobHandleFunc)
		jobGroup.POST("/GetJobList", job.GetJobListHandleFunc)
		jobGroup.POST("/CancelJobInstance", job.CancelJobHandleFunc)
		jobGroup.POST("/GetDAGByPql", job.GetJobDagByPqlHandlerFunc)
		jobGroup.POST("/GetJobInstanceList", job.GetJobInstanceListHandleFunc)
		jobGroup.POST("/GetJobStatisticInfo", job.GetJobInstanceListHandleFunc)
		jobGroup.POST("/StartJob", job.StartJobHandleFunc)
		jobGroup.POST("/GetResult", job.GetResultHandleFunc)
		jobGroup.POST("/GetMinioUrl", job.GetResultUrlHandleFunc)
		jobGroup.POST("/SetResultServerAddr", job.SetResultServerAddrHandleFunc)
	}

	jobInstanceGroup := rootGroup.Group("/jobInstance")
	{
		jobInstanceGroup.POST("/GetJobStatisticInfo", jobInstance.GetJobStatisticInfoHandleFunc)
	}

	jobApproveGroup := rootGroup.Group("/jobApprove")
	{
		jobApproveGroup.POST("/CreateJobApprove", job.CreateJobApproveHandleFunc)
		jobApproveGroup.POST("/GetJobApprove", job.GetJobApproveHandleFunc)
		jobApproveGroup.POST("/GetJobApproveList", job.GetJobApproveListHandleFunc)
	}

	portsGroup := rootGroup.Group("/ports")
	{
		portsGroup.GET("/GetAvailableAddressList", port.GetAvailableAddressListHandleFunc)
	}

	computingResourceGroup := rootGroup.Group("/computingResource")
	{
		computingResourceGroup.POST("/getNodeList", computingResource.GetComputingResourceNodeCardListPageHandleFunc)
		computingResourceGroup.POST("/createGroup", computingResource.CreateComputingResourceGroupHandleFunc)
		computingResourceGroup.POST("/getLocalGroupList", computingResource.GetLocalComputingResourceGroupPageHandleFunc)
		computingResourceGroup.POST("/unavailableGlobalGroup", computingResource.UnpublishComputingResourceGroupHandleFunc)
		computingResourceGroup.POST("/availableGlobalGroup", computingResource.RepublishComputingResourceGroupHandleFunc)
		computingResourceGroup.POST("/getGlobalGroupList", computingResource.GetGlobalComputingResourceGroupHandleFunc)
		computingResourceGroup.POST("/getGlobalGroupDetailList", computingResource.GetComputingResourceGroupDetailHandleFunc)
		computingResourceGroup.GET("/getGlobalGroupOrgID", computingResource.GetGlobalComputingResourceGroupPartyListHandleFunc)
	}

	confidentialComputingModelGroup := rootGroup.Group("/confidentialComputings")
	{
		confidentialComputingModelGroup.POST("/model/create", confidentialComputingModel.CreateConfidentialComputingModelHandleFunc)
		confidentialComputingModelGroup.POST("/model/globalGetAll", confidentialComputingModel.GetGlobalConfidentialComputingModelPageHandleFunc)
		confidentialComputingModelGroup.POST("/model/localGetAll", confidentialComputingModel.GetLocalConfidentialComputingModelPageHandleFunc)
		confidentialComputingModelGroup.POST("/model/detail", confidentialComputingModel.GetConfidentialComputingModelDetailHandleFunc)
	}

	// configuration handlers
	configurationGroup := rootGroup.Group("/configuration")
	{
		configurationGroup.POST("/communication/createPortPool", configuration.CreateIpPortPoolHandleFunc)
		configurationGroup.GET("/communication/getPortPool", configuration.GetIpPortPoolHandleFunc)
		configurationGroup.POST("/create/secretKey", configuration.CreateSecretKeyHandleFunc)
		configurationGroup.POST("/modify/secretKey", configuration.UpdateSecretKeyHandleFunc)
		configurationGroup.POST("/delete/secretKey", configuration.DeleteSecretKeyHandleFunc)
		configurationGroup.POST("/get/secretKey", configuration.GetSecretKeyDetailHandleFunc)
		configurationGroup.POST("/getAll/secretKey", configuration.GetSecretKeyListHandleFunc)
		configurationGroup.POST("/getAllPage/secretKey", configuration.GetSecretKeyListPageHandleFunc)
		configurationGroup.POST("/create/TLSCert", configuration.CreateCertHandleFunc)
		configurationGroup.POST("/modify/TLSCert", configuration.UpdateCertHandleFunc)
		configurationGroup.POST("/delete/TLSCert", configuration.DeleteCertHandleFunc)
		configurationGroup.POST("/get/TLSCert", configuration.GetCertDetailHandleFunc)
		configurationGroup.POST("/getAll/TLSCert", configuration.GetCertListHandleFunc)
		configurationGroup.POST("/getAllPage/TLSCert", configuration.GetCertListPageHandleFunc)
		configurationGroup.POST("/create/localComputingResourceNode", configuration.CreateComputingResourceNodeHandleFunc)
		configurationGroup.POST("/modify/localComputingResourceNode", configuration.UpdateComputingResourceNodeHandleFunc)
		configurationGroup.POST("/delete/localComputingResourceNode", configuration.DeleteComputingResourceNodeHandleFunc)
		configurationGroup.POST("/get/localComputingResourceNode", configuration.GetComputingResourceNodeDetailHandleFunc)
		configurationGroup.POST("/getAllPage/localComputingResourceNode", configuration.GetComputingResourceNodeListPageHandleFunc)
		configurationGroup.POST("/GetPartyInfo", configuration.GetPartyInfoHandleFunc)
	}
}
