/**
 * @Author: xueyanghan
 * @File: request_middleware.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/8 20:41
 */

package middleware

import (
	"bytes"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"encoding/json"
	"github.com/gin-gonic/gin"
	"io"
	"net/http"
)

func MissionsMiddleware() gin.HandlerFunc {
	return func(c *gin.Context) {
		// 将参数添加到请求体的JSON中
		bodyBytes, err := io.ReadAll(c.Request.Body)
		if err != nil {
			logger.Errorf("Failed to read request body: %v", err)
			c.JSON(http.StatusBadRequest, gin.H{"error": err.Error()})
			return
		}

		c.Request.Body.Close()

		newBody, err := addHeadersToRequestBodyDefault(bodyBytes)
		if err != nil {
			logger.Errorf("Failed to add headers to request body: %v", err)
			c.JSON(http.StatusBadRequest, gin.H{"error": err.Error()})
			return
		}
		c.Request.Body = io.NopCloser(bytes.NewReader(newBody))
		c.Next()
	}
}

func addHeadersToRequestBodyDefault(body []byte) ([]byte, error) {
	// 解析请求体的JSON
	var requestBody map[string]interface{}
	if len(body) != 0 {
		if err := json.Unmarshal(body, &requestBody); err != nil {
			return nil, err
		}
	} else {
		requestBody = make(map[string]interface{})
	}

	chainInfoId, ok := requestBody["ChainInfoId"].(int)
	if !ok || chainInfoId == 0 {
		chainListInfo, err := service.MiraIdaAccessServiceImpl.GetListChainInfo("default-id")
		if err != nil {
			logger.Errorf("get chain info failed, err: %v", err)
			return nil, err
		}

		// 默认使用第一个链
		defaultChainId := chainListInfo.List[0].Id
		requestBody["ChainInfoId"] = int(defaultChainId)
	}

	requestId, ok := requestBody["RequestId"].(string)
	if !ok || requestId == "" {
		requestBody["RequestId"] = "default-id"
	}

	// no lint
	newBody, err := json.Marshal(requestBody)
	if err != nil {
		return nil, err
	}
	return newBody, nil
}
