/**
 * @Author: xueyanghan
 * @File: request_middleware.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/8 20:41
 */

package middleware

import (
	"bytes"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"encoding/json"
	"github.com/gin-gonic/gin"
	"io"
	"net/http"
	"strconv"
)

func HeaderToBodyMiddleware() gin.HandlerFunc {
	return func(c *gin.Context) {
		if c.ContentType() == "multipart/form-data" {
			return
		}
		// 从请求头中获取需要转换的参数
		requestId := c.GetHeader(common.RequestIdKey)
		userId := c.GetHeader(common.UserIdKey)
		chainInfoId := c.GetHeader(common.ChainInfoIdKey)
		chainInfoIdx := 0
		if len(chainInfoId) == 0 {
			chainInfoIdx = 0
		} else {
			chainInfoIdxTmp, err := strconv.Atoi(chainInfoId)
			if err != nil {
				logger.Errorf("Failed to convert chainInfoId to int: %v", err)
				c.JSON(http.StatusBadRequest, gin.H{"error": err.Error()})
				return
			}
			chainInfoIdx = chainInfoIdxTmp
		}
		// 将参数添加到请求体的JSON中
		bodyBytes, err := io.ReadAll(c.Request.Body)
		if err != nil {
			logger.Errorf("Failed to read request body: %v", err)
			c.JSON(http.StatusBadRequest, gin.H{"error": err.Error()})
			return
		}
		//logger.Debugf("Request Body2   :%s", string(bodyBytes))
		c.Request.Body.Close()
		newBody, err := addHeadersToRequestBody(bodyBytes, requestId, userId, chainInfoIdx)
		if err != nil {
			logger.Errorf("Failed to add headers to request body: %v", err)
			c.JSON(http.StatusBadRequest, gin.H{"error": err.Error()})
			return
		}
		c.Request.Body = io.NopCloser(bytes.NewReader(newBody))

		c.Next()
	}
}

func addHeadersToRequestBody(body []byte, requestId, userId string, chainInfoIdx int) ([]byte, error) {
	// 解析请求体的JSON
	var requestBody map[string]interface{}
	if len(body) != 0 {
		if err := json.Unmarshal(body, &requestBody); err != nil {
			return nil, err
		}
	} else {
		requestBody = make(map[string]interface{})
	}

	//logger.Debugf("requestBody: %v\n", requestBody)

	// 添加新的参数到JSON中
	requestBody["RequestId"] = requestId
	requestBody["UserId"] = userId
	requestBody["ChainInfoId"] = chainInfoIdx

	// no lint
	newBody, err := json.Marshal(requestBody)
	if err != nil {
		return nil, err
	}
	return newBody, nil
}
