/**
 * @Author: xueyanghan
 * @File: weblog_middleware.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/9 09:36
 */

package middleware

import (
	"bytes"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
	"io/ioutil"
	"time"
)

type responseWriter struct {
	gin.ResponseWriter
	b *bytes.Buffer
}

func (w responseWriter) Write(b []byte) (int, error) {
	w.b.Write(b)
	return w.ResponseWriter.Write(b)
}

func WebLogMiddleware() gin.HandlerFunc {
	return func(c *gin.Context) {
		startTime := time.Now()

		// 打印请求相关参数
		logger.Debug("========================================== Start ==========================================")
		// 打印请求 URL
		logger.Debugf("URL            :%s", c.Request.URL.String())
		// 打印 HTTP method
		logger.Debugf("HTTP Method    :%s", c.Request.Method)
		// 打印调用 handler 的全路径以及执行方法
		logger.Debugf("Handler Method :%s", c.HandlerName())
		// 打印请求的 IP
		logger.Debugf("IP             :%s", c.ClientIP())
		// 打印请求头
		logger.Debugf("Request Header :%s", c.Request.Header)
		// 打印请求入参
		logger.Debugf("Request Params :%s", c.Params)
		// 打印请求body
		// 将参数添加到请求体的JSON中
		bodyBytes, _ := ioutil.ReadAll(c.Request.Body)
		logger.Debugf("Request Body   :%s", string(bodyBytes))
		// 重置body
		c.Request.Body = ioutil.NopCloser(bytes.NewReader(bodyBytes))

		writer := responseWriter{
			c.Writer,
			bytes.NewBuffer([]byte{}),
		}
		c.Writer = writer

		// 继续处理请求
		c.Next()

		// 打印出参
		logger.Debugf("Response Status  :%d", c.Writer.Status())
		logger.Debugf("Response  	  :%s", writer.b.String())

		// 执行耗时
		logger.Debugf("Time-Consuming  :%s", time.Since(startTime))
		logger.Debug("=========================================== Success ===========================================")
	}
}
