/**
 * @Author: xueyanghan
 * @File: ida_access_service_callcontract.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/23 18:39
 */

package service

import (
	"chainweaver.org.cn/chainweaver/ida/chain-service/pb/chainpb"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-ida-access-service/pb"
	"context"
	"github.com/pkg/errors"
	"net/http"
)

func (m miraIdaAccessService) InvokeContract(requestId string, chainInfoId int, ContractName, method string, kvPairs []*chainpb.KeyValuePair) (string, error) {
	request := &pb.CallContractRequest{
		RequestId:      requestId,
		ChainInfoId:    int32(chainInfoId),
		ContractType:   ContractName,
		ContractMethod: method,
		MethodType:     chainpb.MethodType_Invoke,
		KvPairs:        kvPairs,
	}
	contractResponse, err := m.cli.CallContract(context.Background(), request)
	if err != nil {
		logger.Errorf("create job failed, err: %v", err)
		return "", err
	}

	if contractResponse.Code != http.StatusOK {
		return "", errors.Wrapf(errors.New(contractResponse.Msg), "invoke contract failed")
	}
	txId := contractResponse.GetChainDataInfo().GetTxId()

	return txId, nil
}

func (m miraIdaAccessService) QueryContract(requestId string, chainInfoId int, ContractName, method string, kvPairs []*chainpb.KeyValuePair) (string, error) {
	request := &pb.CallContractRequest{
		RequestId:      requestId,
		ChainInfoId:    int32(chainInfoId),
		ContractType:   ContractName,
		ContractMethod: method,
		MethodType:     chainpb.MethodType_Query,
		KvPairs:        kvPairs,
	}
	contractResponse, err := m.cli.CallContract(context.Background(), request)
	if err != nil {
		logger.Errorf("create job failed, err: %v", err)
		return "", err
	}

	if contractResponse.Code != http.StatusOK {
		return "", errors.Wrapf(errors.New(contractResponse.Msg), "query contract failed")
	}
	res := string(contractResponse.ChainDataInfo.Result)

	return res, nil
}
