package service

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/config"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/utils"
	miraConfig "chainweaver.org.cn/chainweaver/mira/mira-common/config"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess/dbaccess_impl"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
)

var KeyServiceAccessService *dbaccess_impl.DBAccessServiceImpl

// InitKeyServiceAccessService init key service db service
func InitKeyServiceAccessService() error {
	keyServiceDBName := config.Conf.KeyServiceConfig.KeyServiceDBName
	if keyServiceDBName == "" {
		keyServiceDBName = "keyservice"
	}
	keyServiceUrl := utils.ConvertKeyServiceDBUrl(config.Conf.DB.URL, keyServiceDBName)
	keyServiceDB := miraConfig.DBConfig{
		Type: config.Conf.DB.Type,
		URL:  keyServiceUrl,
	}
	keyServiceAccess, err := dbaccess_impl.InitKeyServiceDBAccessService(&keyServiceDB)
	if err != nil {
		logger.Errorf("failed to initialize key service db: %v", err)
		return err
	}
	KeyServiceAccessService = keyServiceAccess
	return nil
}
