package utils

import (
	"fmt"
	"testing"
)

func TestConvertKeyServiceDBUrl(t *testing.T) {
	connectionString := "root:12345678@tcp(127.0.0.1:3306)/mira?charset=utf8&parseTime=true&loc=Asia%2FShanghai"
	newDBName := "keyservice"
	expected := "root:12345678@tcp(127.0.0.1:3306)/keyservice?charset=utf8&parseTime=true&loc=Asia%2FShanghai"
	actual := ConvertKeyServiceDBUrl(connectionString, newDBName)
	fmt.Println(actual)
	if actual != expected {
		t.Errorf("expected %s, got %s", expected, actual)
	}
}
