/**
 * @Author: xueyanghan
 * @File: typeConvert.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/9 17:20
 */

package utils

import (
	"strings"

	"chainweaver.org.cn/chainweaver/ida/common/pb/commonpb"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types/comm"
)

func Filters2PbFilters(filters []comm.Filter) []*commonpb.Filter {
	var pbFilters []*commonpb.Filter
	for _, filter := range filters {
		pbFilter := &commonpb.Filter{
			Key:    filter.Key,
			Values: filter.Values,
		}
		pbFilters = append(pbFilters, pbFilter)
	}
	return pbFilters
}

// ConvertKeyServiceDBUrl 修改数据库的名称
func ConvertKeyServiceDBUrl(connectionString, newDBName string) string {
	start := strings.Index(connectionString, "/") + 1
	end := strings.Index(connectionString, "?")
	modified := connectionString[:start] + newDBName
	if end != -1 {
		modified += connectionString[end:]
	}
	return modified
}
