package utils

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestUUID(t *testing.T) {
	uuid := UUID()
	t.Logf("uuid: %s", uuid)
	assert.Equal(t, 36, len(uuid), "uuid length should be 36")

	uuids := strings.Split(uuid, "_")
	assert.Equal(t, 5, len(uuids), "uuids length should be 5")
	assert.Equal(t, 8, len(uuids[0]), "uuid length should be 8")
	assert.Equal(t, 4, len(uuids[1]), "uuid length should be 4")
	assert.Equal(t, 4, len(uuids[2]), "uuid length should be 4")
	assert.Equal(t, 4, len(uuids[3]), "uuid length should be 4")
	assert.Equal(t, 12, len(uuids[4]), "uuid length should be 12")
}
